package jamezo97.clonecraft.network;

import org.apache.commons.lang3.ArrayUtils;

import jamezo97.clonecraft.entity.clone.EntityClone;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.INetworkManager;
import cpw.mods.fml.relauncher.Side;

public class Handler13UpdateEntity extends Handler{
	
	@Value(id = 0)
	int entityId;
	
	@Value(id = 1)
	int[] values;
	
	@Value(id = 2)
	boolean setOrRemove;
	
	@Value(id = 3)
	boolean clearFirst;
	
	public Handler13UpdateEntity() {
		
	}
	
	public void print(int[] vals){
		if(values != null){
			for(int a = 0; a < vals.length; a++){
				System.out.print(vals[a] + ",");
			}
			System.out.println();
		}
		
	}
	
	public Handler13UpdateEntity(int entityId, boolean setOrRemove, boolean clearFirst, int... values) {
		this.entityId = entityId;
		this.values = values;
		
		this.setOrRemove = setOrRemove;
		this.clearFirst = clearFirst;
//		System.out.println("In: " + setOrRemove + "|" + clearFirst);
//		print(values);
	}

	@Override
	public void handle(Side side, INetworkManager manager, EntityPlayer player) {
//		System.out.println("Handle: " + setOrRemove + "|" + clearFirst);
//		print(values);
		if(side == Side.CLIENT){
			EntityClone clone = getCloneOnClient(entityId);
			if(clone != null){
				if(clearFirst){
					clone.options.clearEntitiesToAttack();
				}
				if(setOrRemove){
					clone.options.addEntitiesToAttack(values);
				}else{
					clone.options.removeEntitiesToAttack(values);
				}
			}
		}else if(side == Side.SERVER){
			EntityClone clone = getCloneOnServer(entityId, player.worldObj.provider.dimensionId);
			if(clone != null && clone.canUseThisEntity(player.username)){
				if(clearFirst){
					clone.options.clearEntitiesToAttack();
				}
				if(setOrRemove){
					clone.options.addEntitiesToAttack(values);
				}else{
					clone.options.removeEntitiesToAttack(values);
				}
				new Handler13UpdateEntity(entityId, true, true, clone.options.getAllEntities()).sendToClients(clone.getWatchingOwners());
			}
		}
	}
	

}
